IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CANCELA_RESERVA_CREDITO_ICMS_ST_PIS_COFINS]') 
					AND type in (N'P', N'PC'))
	BEGIN
		DROP PROCEDURE [DBO].[P_CANCELA_RESERVA_CREDITO_ICMS_ST_PIS_COFINS]
	END
GO

CREATE PROCEDURE [dbo].[P_CANCELA_RESERVA_CREDITO_ICMS_ST_PIS_COFINS]
    @PROT_ICMS_ST INT
AS
BEGIN
    DECLARE @TOTAL INT;

    -- Verificar se o registro pode ser cancelado
    SELECT @TOTAL = COUNT(*) FROM EST_NF_ENT_ENTRADA_ICMS_ST_MOV WHERE PROT_ICMS_ST = @PROT_ICMS_ST AND STATUS = 0;

    IF (@TOTAL = 0)
    BEGIN
        -- Registro no encontrado, retornar mensagem de erro
        PRINT 'Erro: Registro no encontrado ou j est cancelado.';
        RETURN;
    END
    ELSE
    BEGIN
        -- Cancelar a Reserva
        UPDATE EST_NF_ENT_ENTRADA_ICMS_ST_MOV SET STATUS = 2 WHERE PROT_ICMS_ST = @PROT_ICMS_ST AND STATUS = 0;
        
        PRINT 'Reserva cancelada com sucesso.';
    END
END
GO


